FUNCTION_BLOCK PMC_ConfigDO2Disp
	CASE CmdSta OF
		0:  (* IDLING*)
			(*check if the rising edge of execute*)
			IF (PreExecute = FALSE) AND (Execute = TRUE) THEN
				(*command being triggered*)
				(*Sending Command to PMC*)
				(* read current heart beat of field bus*)
				memcpy(pDest := ADR(cmdHB),pSrc := ADR(FBin_pointer) + P2H_START + P2H_CMDC_OFFSET,length := 1);
				(*update command heart beat*)
				cmdHB := cmdHB + 1;
				cmdHB := cmdHB AND 255;
				(*--------------write command info*)
				(*command ID*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_CMDID_OFFSET,pSrc := ADR(cmdID),length := 2);
				IF nDO > maxNDo THEN
					(* Statement section IF*)
					doNum := maxNDo;
				ELSE
					doNum := nDO;
				END_IF;
	            
				(*Number of Digital output:*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 5,pSrc := ADR(doNum),length := 1);
				FOR xIndex := 0 TO doNum - 1 DO
					(* Statement section FOR*)
					(*Digital Output ID: *)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 6 + xIndex * 17,pSrc := ADR(DoID[xIndex]),length := 1);
					CASE Type_[xIndex] OF
						0:  (* Motion Start*)
							eventID := 5;
						1:  (* Motion End*)
							eventID := 6;
						2: (*Motion state*)
							eventID := 130;
						ELSE  (* Statement section ELSE*)
							;
					END_CASE;
					(*Event ID: *)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 7 + xIndex * 17,pSrc := ADR(eventID),length := 1);
					(*Trigger Xbot ID: *)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 8 + xIndex * 17,pSrc := ADR(XbotID[xIndex]),length := 1);
					(*Trigger Mode *)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 9 + xIndex * 17,pSrc := ADR(Mode[xIndex]),length := 1);
					(*Threshold*)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 11 + xIndex * 17,pSrc := ADR(Threshold[xIndex]),length := 4);
					(*X Factor*)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 15 + xIndex * 17,pSrc := ADR(XFactor[xIndex]),length := 4);
					(*Y Factor*)
					memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 19 + xIndex * 17,pSrc := ADR(YFactor[xIndex]),length := 4);
				END_FOR;
	            
				(*write command heart beat*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_CMDC_OFFSET,pSrc := ADR(cmdHB),length := 1);
				(*reset output*)
				Error := FALSE;
				ErrorID := 0;
				Done := FALSE;
				Busy := TRUE;
				Aborted := FALSE;
				timeout := 0;
				(*change state to BUSY*)
				CmdSta := 1;
			END_IF;
		1:  (* Waiting for Command return*)
			memcpy(pDest := ADR(cmdHBRtn),pSrc := ADR(FBin_pointer) + P2H_START + P2H_CMDC_OFFSET,length := 1);
			cmdHBRtn := cmdHBRtn AND 255;
			dd := cmdHBRtn - cmdHB;
			IF dd <> 0 THEN
				(*no reply from PMC*)
				timeout := timeout + 1;
				IF timeout > PMC_TIMEOUT THEN
					(* Statement section IF*)
					Error := TRUE;
					ErrorID := 8201;
					CmdSta := 0;
				END_IF;
			ELSE
				(*PMC reply*)
				memcpy(pDest := ADR(cmdIDRtn),pSrc := ADR(FBin_pointer) + P2H_START + P2H_CMDID_OFFSET,length := 2);
				IF cmdIDRtn <> cmdID THEN
					(* Statement section IF*)
					Aborted := TRUE;
				ELSE
					Done := TRUE;
				END_IF;
				memcpy(pDest := ADR(ErrorID),pSrc := ADR(FBin_pointer) + P2H_START + P2H_RTN_OFFSET,length := 2);
				IF ErrorID <> 0 THEN
					(* Statement section IF*)
					Error := TRUE;
				END_IF;
				Busy := FALSE;
				(*change state to IDLE*)
				CmdSta := 0;
			END_IF;
	END_CASE;
	
	(*save execute singnal to local*)
	PreExecute := Execute;

END_FUNCTION_BLOCK
